//
//  YHTravelCertificateTipsCell.swift
//  galaxy
//
//  Created by edy on 2024/8/27.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHTravelCertificateTipsCell: UITableViewCell {

    static let cellReuseIdentifier = "YHTravelCertificateTipsCell"
    
    var userName: String = "" {
        didSet {
            titleLabel.text = "\(userName) 需准备证件清单"
        }
    }
    
    var tipsArr: [ASAttributedString] = [] {
        didSet {
            grayView.removeSubviews()
            var lastTipsView: YHTravelCertificateTipsView?
            for (index, text) in tipsArr.enumerated() {
                let tipsView = YHTravelCertificateTipsView(frame: .zero)
                tipsView.text = text
                grayView.addSubview(tipsView)
                tipsView.snp.makeConstraints { make in
                    make.left.equalTo(16)
                    make.right.equalTo(-16)
                    if let lastTipsView = lastTipsView {
                        make.top.equalTo(lastTipsView.snp.bottom).offset(12)
                    } else {
                        make.top.equalTo(16)
                    }
                    if index == tipsArr.count-1 {
                        make.bottom.equalTo(-16)
                    }
                }
                lastTipsView = tipsView
            }
            self.setNeedsLayout()
            self.layoutIfNeeded()
        }
    }
    
    var markView: UIView = {
        let view = UIView()
        view.backgroundColor = .brandMainColor
        return view
    }()
    
    var titleLabel: UILabel = {
        let label = UILabel()
        label.textColor = UIColor.mainTextColor
        label.font = UIFont.PFSC_M(ofSize: 17)
        label.text = "张山 需准备证件清单"
        label.numberOfLines = 0
        return label
    }()
    
    var grayView: UIView = {
        let view = UIView()
        view.backgroundColor = .init(hex: 0xF8F9FB)
        view.layer.cornerRadius = 4.0
        view.clipsToBounds = true
        return view
    }()
    
    required init?(coder: NSCoder) {
        super.init(coder: coder)
    }
    
    override init(style: UITableViewCell.CellStyle, reuseIdentifier: String?) {
        super.init(style: style, reuseIdentifier: reuseIdentifier)
        setupUI()
    }
    
    func setupUI() {
        
        self.selectionStyle = .none
        contentView.backgroundColor = .white
        contentView.addSubview(markView)
        contentView.addSubview(titleLabel)
        contentView.addSubview(grayView)
        
        markView.snp.makeConstraints { make in
            make.width.equalTo(3)
            make.height.equalTo(14)
            make.left.equalTo(16)
            make.centerY.equalTo(titleLabel)
            
        }
        
        titleLabel.snp.makeConstraints { make in
            make.top.equalTo(20)
            make.left.equalTo(markView.snp.right).offset(8)
            make.right.equalTo(-16)
        }
        
        grayView.snp.makeConstraints { make in
            make.left.equalTo(16)
            make.right.equalTo(-16)
            make.top.equalTo(titleLabel.snp.bottom).offset(16)
            make.bottom.equalTo(-20)
        }
    }

}
